/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.storage;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.item.VariantItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ItemFocus
extends class_1792
implements IotaHolderItem,
VariantItem {
    public static final class_2960 OVERLAY_PRED = HexAPI.modLoc("overlay_layer");
    public static final class_2960 VARIANT_PRED = HexAPI.modLoc("variant");
    public static final int NUM_VARIANTS = 8;
    public static final String TAG_DATA = "data";
    public static final String TAG_SEALED = "sealed";

    public ItemFocus(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    @Override
    @Nullable
    public class_2487 readIotaTag(class_1799 stack) {
        return NBTHelper.getCompound(stack, TAG_DATA);
    }

    public String method_7866(class_1799 stack) {
        return super.method_7866(stack) + (NBTHelper.getBoolean(stack, TAG_SEALED) ? ".sealed" : "");
    }

    @Override
    public boolean writeable(class_1799 stack) {
        return !ItemFocus.isSealed(stack);
    }

    @Override
    public boolean canWrite(class_1799 stack, Iota datum) {
        return datum == null || !ItemFocus.isSealed(stack);
    }

    @Override
    public void writeDatum(class_1799 stack, Iota datum) {
        if (datum == null) {
            stack.method_7983(TAG_DATA);
            stack.method_7983(TAG_SEALED);
        } else if (!ItemFocus.isSealed(stack)) {
            NBTHelper.put(stack, TAG_DATA, (class_2520)IotaType.serialize(datum));
        }
    }

    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltipComponents, class_1836 pIsAdvanced) {
        IotaHolderItem.appendHoverText(this, pStack, pTooltipComponents, pIsAdvanced);
    }

    public static boolean isSealed(class_1799 stack) {
        return NBTHelper.getBoolean(stack, TAG_SEALED);
    }

    public static void seal(class_1799 stack) {
        NBTHelper.putBoolean(stack, TAG_SEALED, true);
    }

    @Override
    public int numVariants() {
        return 8;
    }

    @Override
    public void setVariant(class_1799 stack, int variant) {
        if (!ItemFocus.isSealed(stack)) {
            NBTHelper.putInt(stack, "variant", this.clampVariant(variant));
        }
    }
}

